//===========
//Scope:
//pseudo-inventory responsible for the zooming in for each appropriate weapon.
//===========

#exec AUDIO IMPORT FILE="Sounds\Click.WAV" NAME="click" GROUP="Weapons"

class Scope extends Inventory;

var PlayerPawn PP;
var() texture SghtTint[5], UseTint;
var() bool bUseARifle, bUseBazooka;
var int TintCount;

exec function arcxzoomin()
{
	PP = PlayerPawn(Owner);
	if (PP.weapon != None && PP.weapon.IsA('Respawnables_Weapon_Bazooka') && PP.weapon.isinstate('idle'))
		{
  			GotoState('Zooming');
		}
}

exec function arcxchangetint()
{
	local PlayerPawn PP;

	PP = PlayerPawn(Owner);
	if (PP.weapon != None && PP.weapon.IsA('Respawnables_Weapon_Bazooka') && PP.weapon.isinstate('idle'))
	{
		GotoState('doChangeTint');
	}
}

state doChangeTint
{
	function ChangeTint()
	{
		if ( TintCount == 4 ) TintCount = 0;
		else TintCount++;

		UseTint = SghtTint[TintCount];

		PlayOwnedSound(sound'click', SLOT_None, Pawn(owner).SoundDampening);
	} 

Begin:
	ChangeTint();
	Sleep(0.25);
}

state Zooming
{
     function endstate()
     {
     super.endstate();
     }

     function DoBazookaZoom()
	{
     		if (playerpawn(owner) != none)
        		{
         		if (playerpawn(owner).desiredfov == playerpawn(owner).defaultfov)
         		    	playerpawn(owner).desiredfov = 30;
        		else
				playerpawn(owner).desiredfov = playerpawn(owner).defaultfov;
       			}
	}

begin:
	if (PlayerPawn(Owner).weapon.IsA('Respawnables_Weapon_Bazooka')) DoBazookaZoom();
	PlayOwnedSound(sound'click', SLOT_None, Pawn(owner).SoundDampening);
	Sleep(0.25);
}

function Tick(float Deltatime)
{
	if (bUseBazooka && !PlayerPawn(Owner).weapon.IsA('Respawnables_Weapon_Bazooka')) Destroy();
}

defaultproperties
{
    SghtTint(0)=Texture'sight'
    SghtTint(1)=Texture'sight'
    SghtTint(2)=Texture'sight'
    SghtTint(3)=Texture'sight'
    SghtTint(4)=Texture'sight'
    UseTint=Texture'sight'
}
